﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/deadline/model/SearchStepsResult.h>

#include <utility>

using namespace Aws::deadline::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

SearchStepsResult::SearchStepsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

SearchStepsResult& SearchStepsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("steps")) {
    Aws::Utils::Array<JsonView> stepsJsonList = jsonValue.GetArray("steps");
    for (unsigned stepsIndex = 0; stepsIndex < stepsJsonList.GetLength(); ++stepsIndex) {
      m_steps.push_back(stepsJsonList[stepsIndex].AsObject());
    }
    m_stepsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("nextItemOffset")) {
    m_nextItemOffset = jsonValue.GetInteger("nextItemOffset");
    m_nextItemOffsetHasBeenSet = true;
  }
  if (jsonValue.ValueExists("totalResults")) {
    m_totalResults = jsonValue.GetInteger("totalResults");
    m_totalResultsHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
