﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/deadline/model/UpdateJobRequest.h>

#include <utility>

using namespace Aws::deadline::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String UpdateJobRequest::SerializePayload() const {
  JsonValue payload;

  if (m_targetTaskRunStatusHasBeenSet) {
    payload.WithString("targetTaskRunStatus", JobTargetTaskRunStatusMapper::GetNameForJobTargetTaskRunStatus(m_targetTaskRunStatus));
  }

  if (m_priorityHasBeenSet) {
    payload.WithInteger("priority", m_priority);
  }

  if (m_maxFailedTasksCountHasBeenSet) {
    payload.WithInteger("maxFailedTasksCount", m_maxFailedTasksCount);
  }

  if (m_maxRetriesPerTaskHasBeenSet) {
    payload.WithInteger("maxRetriesPerTask", m_maxRetriesPerTask);
  }

  if (m_lifecycleStatusHasBeenSet) {
    payload.WithString("lifecycleStatus", UpdateJobLifecycleStatusMapper::GetNameForUpdateJobLifecycleStatus(m_lifecycleStatus));
  }

  if (m_maxWorkerCountHasBeenSet) {
    payload.WithInteger("maxWorkerCount", m_maxWorkerCount);
  }

  if (m_nameHasBeenSet) {
    payload.WithString("name", m_name);
  }

  if (m_descriptionHasBeenSet) {
    payload.WithString("description", m_description);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection UpdateJobRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  Aws::StringStream ss;
  if (m_clientTokenHasBeenSet) {
    ss << m_clientToken;
    headers.emplace("x-amz-client-token", ss.str());
    ss.str("");
  }

  return headers;
}
