﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/devops-guru/model/DescribeAccountHealthResult.h>

#include <utility>

using namespace Aws::DevOpsGuru::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

DescribeAccountHealthResult::DescribeAccountHealthResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

DescribeAccountHealthResult& DescribeAccountHealthResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("OpenReactiveInsights")) {
    m_openReactiveInsights = jsonValue.GetInteger("OpenReactiveInsights");
    m_openReactiveInsightsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("OpenProactiveInsights")) {
    m_openProactiveInsights = jsonValue.GetInteger("OpenProactiveInsights");
    m_openProactiveInsightsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("MetricsAnalyzed")) {
    m_metricsAnalyzed = jsonValue.GetInteger("MetricsAnalyzed");
    m_metricsAnalyzedHasBeenSet = true;
  }
  if (jsonValue.ValueExists("ResourceHours")) {
    m_resourceHours = jsonValue.GetInt64("ResourceHours");
    m_resourceHoursHasBeenSet = true;
  }
  if (jsonValue.ValueExists("AnalyzedResourceCount")) {
    m_analyzedResourceCount = jsonValue.GetInt64("AnalyzedResourceCount");
    m_analyzedResourceCountHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
