﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/dynamodb/model/DescribeExportRequest.h>

#include <utility>

using namespace Aws::DynamoDB::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String DescribeExportRequest::SerializePayload() const {
  JsonValue payload;

  if (m_exportArnHasBeenSet) {
    payload.WithString("ExportArn", m_exportArn);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DescribeExportRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "DynamoDB_20120810.DescribeExport"));
  return headers;
}

DescribeExportRequest::EndpointParameters DescribeExportRequest::GetEndpointContextParams() const {
  EndpointParameters parameters;
  // Operation context parameters
  if (ExportArnHasBeenSet()) {
    parameters.emplace_back(Aws::String("ResourceArn"), this->GetExportArn(),
                            Aws::Endpoint::EndpointParameter::ParameterOrigin::OPERATION_CONTEXT);
  }
  return parameters;
}
