﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/dynamodb/model/TableCreationParameters.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace DynamoDB {
namespace Model {

TableCreationParameters::TableCreationParameters(JsonView jsonValue) { *this = jsonValue; }

TableCreationParameters& TableCreationParameters::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("TableName")) {
    m_tableName = jsonValue.GetString("TableName");
    m_tableNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("AttributeDefinitions")) {
    Aws::Utils::Array<JsonView> attributeDefinitionsJsonList = jsonValue.GetArray("AttributeDefinitions");
    for (unsigned attributeDefinitionsIndex = 0; attributeDefinitionsIndex < attributeDefinitionsJsonList.GetLength();
         ++attributeDefinitionsIndex) {
      m_attributeDefinitions.push_back(attributeDefinitionsJsonList[attributeDefinitionsIndex].AsObject());
    }
    m_attributeDefinitionsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("KeySchema")) {
    Aws::Utils::Array<JsonView> keySchemaJsonList = jsonValue.GetArray("KeySchema");
    for (unsigned keySchemaIndex = 0; keySchemaIndex < keySchemaJsonList.GetLength(); ++keySchemaIndex) {
      m_keySchema.push_back(keySchemaJsonList[keySchemaIndex].AsObject());
    }
    m_keySchemaHasBeenSet = true;
  }
  if (jsonValue.ValueExists("BillingMode")) {
    m_billingMode = BillingModeMapper::GetBillingModeForName(jsonValue.GetString("BillingMode"));
    m_billingModeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("ProvisionedThroughput")) {
    m_provisionedThroughput = jsonValue.GetObject("ProvisionedThroughput");
    m_provisionedThroughputHasBeenSet = true;
  }
  if (jsonValue.ValueExists("OnDemandThroughput")) {
    m_onDemandThroughput = jsonValue.GetObject("OnDemandThroughput");
    m_onDemandThroughputHasBeenSet = true;
  }
  if (jsonValue.ValueExists("SSESpecification")) {
    m_sSESpecification = jsonValue.GetObject("SSESpecification");
    m_sSESpecificationHasBeenSet = true;
  }
  if (jsonValue.ValueExists("GlobalSecondaryIndexes")) {
    Aws::Utils::Array<JsonView> globalSecondaryIndexesJsonList = jsonValue.GetArray("GlobalSecondaryIndexes");
    for (unsigned globalSecondaryIndexesIndex = 0; globalSecondaryIndexesIndex < globalSecondaryIndexesJsonList.GetLength();
         ++globalSecondaryIndexesIndex) {
      m_globalSecondaryIndexes.push_back(globalSecondaryIndexesJsonList[globalSecondaryIndexesIndex].AsObject());
    }
    m_globalSecondaryIndexesHasBeenSet = true;
  }
  return *this;
}

JsonValue TableCreationParameters::Jsonize() const {
  JsonValue payload;

  if (m_tableNameHasBeenSet) {
    payload.WithString("TableName", m_tableName);
  }

  if (m_attributeDefinitionsHasBeenSet) {
    Aws::Utils::Array<JsonValue> attributeDefinitionsJsonList(m_attributeDefinitions.size());
    for (unsigned attributeDefinitionsIndex = 0; attributeDefinitionsIndex < attributeDefinitionsJsonList.GetLength();
         ++attributeDefinitionsIndex) {
      attributeDefinitionsJsonList[attributeDefinitionsIndex].AsObject(m_attributeDefinitions[attributeDefinitionsIndex].Jsonize());
    }
    payload.WithArray("AttributeDefinitions", std::move(attributeDefinitionsJsonList));
  }

  if (m_keySchemaHasBeenSet) {
    Aws::Utils::Array<JsonValue> keySchemaJsonList(m_keySchema.size());
    for (unsigned keySchemaIndex = 0; keySchemaIndex < keySchemaJsonList.GetLength(); ++keySchemaIndex) {
      keySchemaJsonList[keySchemaIndex].AsObject(m_keySchema[keySchemaIndex].Jsonize());
    }
    payload.WithArray("KeySchema", std::move(keySchemaJsonList));
  }

  if (m_billingModeHasBeenSet) {
    payload.WithString("BillingMode", BillingModeMapper::GetNameForBillingMode(m_billingMode));
  }

  if (m_provisionedThroughputHasBeenSet) {
    payload.WithObject("ProvisionedThroughput", m_provisionedThroughput.Jsonize());
  }

  if (m_onDemandThroughputHasBeenSet) {
    payload.WithObject("OnDemandThroughput", m_onDemandThroughput.Jsonize());
  }

  if (m_sSESpecificationHasBeenSet) {
    payload.WithObject("SSESpecification", m_sSESpecification.Jsonize());
  }

  if (m_globalSecondaryIndexesHasBeenSet) {
    Aws::Utils::Array<JsonValue> globalSecondaryIndexesJsonList(m_globalSecondaryIndexes.size());
    for (unsigned globalSecondaryIndexesIndex = 0; globalSecondaryIndexesIndex < globalSecondaryIndexesJsonList.GetLength();
         ++globalSecondaryIndexesIndex) {
      globalSecondaryIndexesJsonList[globalSecondaryIndexesIndex].AsObject(m_globalSecondaryIndexes[globalSecondaryIndexesIndex].Jsonize());
    }
    payload.WithArray("GlobalSecondaryIndexes", std::move(globalSecondaryIndexesJsonList));
  }

  return payload;
}

}  // namespace Model
}  // namespace DynamoDB
}  // namespace Aws
