﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/es/model/AutoTuneDetails.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace ElasticsearchService {
namespace Model {

AutoTuneDetails::AutoTuneDetails(JsonView jsonValue) { *this = jsonValue; }

AutoTuneDetails& AutoTuneDetails::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("ScheduledAutoTuneDetails")) {
    m_scheduledAutoTuneDetails = jsonValue.GetObject("ScheduledAutoTuneDetails");
    m_scheduledAutoTuneDetailsHasBeenSet = true;
  }
  return *this;
}

JsonValue AutoTuneDetails::Jsonize() const {
  JsonValue payload;

  if (m_scheduledAutoTuneDetailsHasBeenSet) {
    payload.WithObject("ScheduledAutoTuneDetails", m_scheduledAutoTuneDetails.Jsonize());
  }

  return payload;
}

}  // namespace Model
}  // namespace ElasticsearchService
}  // namespace Aws
