﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/eventbridge/model/CreateArchiveRequest.h>

#include <utility>

using namespace Aws::EventBridge::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String CreateArchiveRequest::SerializePayload() const {
  JsonValue payload;

  if (m_archiveNameHasBeenSet) {
    payload.WithString("ArchiveName", m_archiveName);
  }

  if (m_eventSourceArnHasBeenSet) {
    payload.WithString("EventSourceArn", m_eventSourceArn);
  }

  if (m_descriptionHasBeenSet) {
    payload.WithString("Description", m_description);
  }

  if (m_eventPatternHasBeenSet) {
    payload.WithString("EventPattern", m_eventPattern);
  }

  if (m_retentionDaysHasBeenSet) {
    payload.WithInteger("RetentionDays", m_retentionDays);
  }

  if (m_kmsKeyIdentifierHasBeenSet) {
    payload.WithString("KmsKeyIdentifier", m_kmsKeyIdentifier);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection CreateArchiveRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AWSEvents.CreateArchive"));
  return headers;
}
