﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/evs/model/NetworkInterface.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace EVS {
namespace Model {

NetworkInterface::NetworkInterface(JsonView jsonValue) { *this = jsonValue; }

NetworkInterface& NetworkInterface::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("networkInterfaceId")) {
    m_networkInterfaceId = jsonValue.GetString("networkInterfaceId");
    m_networkInterfaceIdHasBeenSet = true;
  }
  return *this;
}

JsonValue NetworkInterface::Jsonize() const {
  JsonValue payload;

  if (m_networkInterfaceIdHasBeenSet) {
    payload.WithString("networkInterfaceId", m_networkInterfaceId);
  }

  return payload;
}

}  // namespace Model
}  // namespace EVS
}  // namespace Aws
