﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/forecast/model/DescribeExplainabilityResult.h>

#include <utility>

using namespace Aws::ForecastService::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

DescribeExplainabilityResult::DescribeExplainabilityResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

DescribeExplainabilityResult& DescribeExplainabilityResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("ExplainabilityArn")) {
    m_explainabilityArn = jsonValue.GetString("ExplainabilityArn");
    m_explainabilityArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("ExplainabilityName")) {
    m_explainabilityName = jsonValue.GetString("ExplainabilityName");
    m_explainabilityNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("ResourceArn")) {
    m_resourceArn = jsonValue.GetString("ResourceArn");
    m_resourceArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("ExplainabilityConfig")) {
    m_explainabilityConfig = jsonValue.GetObject("ExplainabilityConfig");
    m_explainabilityConfigHasBeenSet = true;
  }
  if (jsonValue.ValueExists("EnableVisualization")) {
    m_enableVisualization = jsonValue.GetBool("EnableVisualization");
    m_enableVisualizationHasBeenSet = true;
  }
  if (jsonValue.ValueExists("DataSource")) {
    m_dataSource = jsonValue.GetObject("DataSource");
    m_dataSourceHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Schema")) {
    m_schema = jsonValue.GetObject("Schema");
    m_schemaHasBeenSet = true;
  }
  if (jsonValue.ValueExists("StartDateTime")) {
    m_startDateTime = jsonValue.GetString("StartDateTime");
    m_startDateTimeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("EndDateTime")) {
    m_endDateTime = jsonValue.GetString("EndDateTime");
    m_endDateTimeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("EstimatedTimeRemainingInMinutes")) {
    m_estimatedTimeRemainingInMinutes = jsonValue.GetInt64("EstimatedTimeRemainingInMinutes");
    m_estimatedTimeRemainingInMinutesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Message")) {
    m_message = jsonValue.GetString("Message");
    m_messageHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Status")) {
    m_status = jsonValue.GetString("Status");
    m_statusHasBeenSet = true;
  }
  if (jsonValue.ValueExists("CreationTime")) {
    m_creationTime = jsonValue.GetDouble("CreationTime");
    m_creationTimeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("LastModificationTime")) {
    m_lastModificationTime = jsonValue.GetDouble("LastModificationTime");
    m_lastModificationTimeHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
