﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/forecast/model/ListDatasetGroupsResult.h>

#include <utility>

using namespace Aws::ForecastService::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListDatasetGroupsResult::ListDatasetGroupsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListDatasetGroupsResult& ListDatasetGroupsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("DatasetGroups")) {
    Aws::Utils::Array<JsonView> datasetGroupsJsonList = jsonValue.GetArray("DatasetGroups");
    for (unsigned datasetGroupsIndex = 0; datasetGroupsIndex < datasetGroupsJsonList.GetLength(); ++datasetGroupsIndex) {
      m_datasetGroups.push_back(datasetGroupsJsonList[datasetGroupsIndex].AsObject());
    }
    m_datasetGroupsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("NextToken")) {
    m_nextToken = jsonValue.GetString("NextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
