﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/geo-places/model/AccessRestriction.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace GeoPlaces {
namespace Model {

AccessRestriction::AccessRestriction(JsonView jsonValue) { *this = jsonValue; }

AccessRestriction& AccessRestriction::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("Restricted")) {
    m_restricted = jsonValue.GetBool("Restricted");
    m_restrictedHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Categories")) {
    Aws::Utils::Array<JsonView> categoriesJsonList = jsonValue.GetArray("Categories");
    for (unsigned categoriesIndex = 0; categoriesIndex < categoriesJsonList.GetLength(); ++categoriesIndex) {
      m_categories.push_back(categoriesJsonList[categoriesIndex].AsObject());
    }
    m_categoriesHasBeenSet = true;
  }
  return *this;
}

JsonValue AccessRestriction::Jsonize() const {
  JsonValue payload;

  if (m_restrictedHasBeenSet) {
    payload.WithBool("Restricted", m_restricted);
  }

  if (m_categoriesHasBeenSet) {
    Aws::Utils::Array<JsonValue> categoriesJsonList(m_categories.size());
    for (unsigned categoriesIndex = 0; categoriesIndex < categoriesJsonList.GetLength(); ++categoriesIndex) {
      categoriesJsonList[categoriesIndex].AsObject(m_categories[categoriesIndex].Jsonize());
    }
    payload.WithArray("Categories", std::move(categoriesJsonList));
  }

  return payload;
}

}  // namespace Model
}  // namespace GeoPlaces
}  // namespace Aws
