﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/geo-places/model/SuggestHighlights.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace GeoPlaces {
namespace Model {

SuggestHighlights::SuggestHighlights(JsonView jsonValue) { *this = jsonValue; }

SuggestHighlights& SuggestHighlights::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("Title")) {
    Aws::Utils::Array<JsonView> titleJsonList = jsonValue.GetArray("Title");
    for (unsigned titleIndex = 0; titleIndex < titleJsonList.GetLength(); ++titleIndex) {
      m_title.push_back(titleJsonList[titleIndex].AsObject());
    }
    m_titleHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Address")) {
    m_address = jsonValue.GetObject("Address");
    m_addressHasBeenSet = true;
  }
  return *this;
}

JsonValue SuggestHighlights::Jsonize() const {
  JsonValue payload;

  if (m_titleHasBeenSet) {
    Aws::Utils::Array<JsonValue> titleJsonList(m_title.size());
    for (unsigned titleIndex = 0; titleIndex < titleJsonList.GetLength(); ++titleIndex) {
      titleJsonList[titleIndex].AsObject(m_title[titleIndex].Jsonize());
    }
    payload.WithArray("Title", std::move(titleJsonList));
  }

  if (m_addressHasBeenSet) {
    payload.WithObject("Address", m_address.Jsonize());
  }

  return payload;
}

}  // namespace Model
}  // namespace GeoPlaces
}  // namespace Aws
