﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/glacier/model/UploadArchiveResult.h>

#include <utility>

using namespace Aws::Glacier::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

UploadArchiveResult::UploadArchiveResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

UploadArchiveResult& UploadArchiveResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  AWS_UNREFERENCED_PARAM(result);

  const auto& headers = result.GetHeaderValueCollection();
  const auto& locationIter = headers.find("location");
  if (locationIter != headers.end()) {
    m_location = locationIter->second;
    m_locationHasBeenSet = true;
  }

  const auto& checksumIter = headers.find("x-amz-sha256-tree-hash");
  if (checksumIter != headers.end()) {
    m_checksum = checksumIter->second;
    m_checksumHasBeenSet = true;
  }

  const auto& archiveIdIter = headers.find("x-amz-archive-id");
  if (archiveIdIter != headers.end()) {
    m_archiveId = archiveIdIter->second;
    m_archiveIdHasBeenSet = true;
  }

  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
