﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/glue/model/CreateIntegrationResourcePropertyResult.h>

#include <utility>

using namespace Aws::Glue::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

CreateIntegrationResourcePropertyResult::CreateIntegrationResourcePropertyResult(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  *this = result;
}

CreateIntegrationResourcePropertyResult& CreateIntegrationResourcePropertyResult::operator=(
    const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("ResourceArn")) {
    m_resourceArn = jsonValue.GetString("ResourceArn");
    m_resourceArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("ResourcePropertyArn")) {
    m_resourcePropertyArn = jsonValue.GetString("ResourcePropertyArn");
    m_resourcePropertyArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("SourceProcessingProperties")) {
    m_sourceProcessingProperties = jsonValue.GetObject("SourceProcessingProperties");
    m_sourceProcessingPropertiesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("TargetProcessingProperties")) {
    m_targetProcessingProperties = jsonValue.GetObject("TargetProcessingProperties");
    m_targetProcessingPropertiesHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
