﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/glue/model/FederationSourceException.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace Glue {
namespace Model {

FederationSourceException::FederationSourceException(JsonView jsonValue) { *this = jsonValue; }

FederationSourceException& FederationSourceException::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("FederationSourceErrorCode")) {
    m_federationSourceErrorCode =
        FederationSourceErrorCodeMapper::GetFederationSourceErrorCodeForName(jsonValue.GetString("FederationSourceErrorCode"));
    m_federationSourceErrorCodeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Message")) {
    m_message = jsonValue.GetString("Message");
    m_messageHasBeenSet = true;
  }
  return *this;
}

JsonValue FederationSourceException::Jsonize() const {
  JsonValue payload;

  if (m_federationSourceErrorCodeHasBeenSet) {
    payload.WithString("FederationSourceErrorCode",
                       FederationSourceErrorCodeMapper::GetNameForFederationSourceErrorCode(m_federationSourceErrorCode));
  }

  if (m_messageHasBeenSet) {
    payload.WithString("Message", m_message);
  }

  return payload;
}

}  // namespace Model
}  // namespace Glue
}  // namespace Aws
