﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/glue/model/GetDataQualityModelResultResult.h>

#include <utility>

using namespace Aws::Glue::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

GetDataQualityModelResultResult::GetDataQualityModelResultResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

GetDataQualityModelResultResult& GetDataQualityModelResultResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("CompletedOn")) {
    m_completedOn = jsonValue.GetDouble("CompletedOn");
    m_completedOnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Model")) {
    Aws::Utils::Array<JsonView> modelJsonList = jsonValue.GetArray("Model");
    for (unsigned modelIndex = 0; modelIndex < modelJsonList.GetLength(); ++modelIndex) {
      m_model.push_back(modelJsonList[modelIndex].AsObject());
    }
    m_modelHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
