﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/glue/model/GetDataQualityResultRequest.h>

#include <utility>

using namespace Aws::Glue::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String GetDataQualityResultRequest::SerializePayload() const {
  JsonValue payload;

  if (m_resultIdHasBeenSet) {
    payload.WithString("ResultId", m_resultId);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection GetDataQualityResultRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AWSGlue.GetDataQualityResult"));
  return headers;
}
