﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/glue/model/S3Encryption.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace Glue {
namespace Model {

S3Encryption::S3Encryption(JsonView jsonValue) { *this = jsonValue; }

S3Encryption& S3Encryption::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("S3EncryptionMode")) {
    m_s3EncryptionMode = S3EncryptionModeMapper::GetS3EncryptionModeForName(jsonValue.GetString("S3EncryptionMode"));
    m_s3EncryptionModeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("KmsKeyArn")) {
    m_kmsKeyArn = jsonValue.GetString("KmsKeyArn");
    m_kmsKeyArnHasBeenSet = true;
  }
  return *this;
}

JsonValue S3Encryption::Jsonize() const {
  JsonValue payload;

  if (m_s3EncryptionModeHasBeenSet) {
    payload.WithString("S3EncryptionMode", S3EncryptionModeMapper::GetNameForS3EncryptionMode(m_s3EncryptionMode));
  }

  if (m_kmsKeyArnHasBeenSet) {
    payload.WithString("KmsKeyArn", m_kmsKeyArn);
  }

  return payload;
}

}  // namespace Model
}  // namespace Glue
}  // namespace Aws
