﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/glue/model/StartBlueprintRunRequest.h>

#include <utility>

using namespace Aws::Glue::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String StartBlueprintRunRequest::SerializePayload() const {
  JsonValue payload;

  if (m_blueprintNameHasBeenSet) {
    payload.WithString("BlueprintName", m_blueprintName);
  }

  if (m_parametersHasBeenSet) {
    payload.WithString("Parameters", m_parameters);
  }

  if (m_roleArnHasBeenSet) {
    payload.WithString("RoleArn", m_roleArn);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection StartBlueprintRunRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AWSGlue.StartBlueprintRun"));
  return headers;
}
