﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/glue/model/TableVersionError.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace Glue {
namespace Model {

TableVersionError::TableVersionError(JsonView jsonValue) { *this = jsonValue; }

TableVersionError& TableVersionError::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("TableName")) {
    m_tableName = jsonValue.GetString("TableName");
    m_tableNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("VersionId")) {
    m_versionId = jsonValue.GetString("VersionId");
    m_versionIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("ErrorDetail")) {
    m_errorDetail = jsonValue.GetObject("ErrorDetail");
    m_errorDetailHasBeenSet = true;
  }
  return *this;
}

JsonValue TableVersionError::Jsonize() const {
  JsonValue payload;

  if (m_tableNameHasBeenSet) {
    payload.WithString("TableName", m_tableName);
  }

  if (m_versionIdHasBeenSet) {
    payload.WithString("VersionId", m_versionId);
  }

  if (m_errorDetailHasBeenSet) {
    payload.WithObject("ErrorDetail", m_errorDetail.Jsonize());
  }

  return payload;
}

}  // namespace Model
}  // namespace Glue
}  // namespace Aws
