﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/inspector/model/InvalidInputException.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace Inspector {
namespace Model {

InvalidInputException::InvalidInputException(JsonView jsonValue) { *this = jsonValue; }

InvalidInputException& InvalidInputException::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("message")) {
    m_message = jsonValue.GetString("message");
    m_messageHasBeenSet = true;
  }
  if (jsonValue.ValueExists("errorCode")) {
    m_errorCode = InvalidInputErrorCodeMapper::GetInvalidInputErrorCodeForName(jsonValue.GetString("errorCode"));
    m_errorCodeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("canRetry")) {
    m_canRetry = jsonValue.GetBool("canRetry");
    m_canRetryHasBeenSet = true;
  }
  return *this;
}

JsonValue InvalidInputException::Jsonize() const {
  JsonValue payload;

  if (m_messageHasBeenSet) {
    payload.WithString("message", m_message);
  }

  if (m_errorCodeHasBeenSet) {
    payload.WithString("errorCode", InvalidInputErrorCodeMapper::GetNameForInvalidInputErrorCode(m_errorCode));
  }

  if (m_canRetryHasBeenSet) {
    payload.WithBool("canRetry", m_canRetry);
  }

  return payload;
}

}  // namespace Model
}  // namespace Inspector
}  // namespace Aws
