﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/iotdeviceadvisor/model/GetSuiteDefinitionResult.h>

#include <utility>

using namespace Aws::IoTDeviceAdvisor::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

GetSuiteDefinitionResult::GetSuiteDefinitionResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

GetSuiteDefinitionResult& GetSuiteDefinitionResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("suiteDefinitionId")) {
    m_suiteDefinitionId = jsonValue.GetString("suiteDefinitionId");
    m_suiteDefinitionIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("suiteDefinitionArn")) {
    m_suiteDefinitionArn = jsonValue.GetString("suiteDefinitionArn");
    m_suiteDefinitionArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("suiteDefinitionVersion")) {
    m_suiteDefinitionVersion = jsonValue.GetString("suiteDefinitionVersion");
    m_suiteDefinitionVersionHasBeenSet = true;
  }
  if (jsonValue.ValueExists("latestVersion")) {
    m_latestVersion = jsonValue.GetString("latestVersion");
    m_latestVersionHasBeenSet = true;
  }
  if (jsonValue.ValueExists("suiteDefinitionConfiguration")) {
    m_suiteDefinitionConfiguration = jsonValue.GetObject("suiteDefinitionConfiguration");
    m_suiteDefinitionConfigurationHasBeenSet = true;
  }
  if (jsonValue.ValueExists("createdAt")) {
    m_createdAt = jsonValue.GetDouble("createdAt");
    m_createdAtHasBeenSet = true;
  }
  if (jsonValue.ValueExists("lastModifiedAt")) {
    m_lastModifiedAt = jsonValue.GetDouble("lastModifiedAt");
    m_lastModifiedAtHasBeenSet = true;
  }
  if (jsonValue.ValueExists("tags")) {
    Aws::Map<Aws::String, JsonView> tagsJsonMap = jsonValue.GetObject("tags").GetAllObjects();
    for (auto& tagsItem : tagsJsonMap) {
      m_tags[tagsItem.first] = tagsItem.second.AsString();
    }
    m_tagsHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
