﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/kafka/model/ConfigurationInfo.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace Kafka {
namespace Model {

ConfigurationInfo::ConfigurationInfo(JsonView jsonValue) { *this = jsonValue; }

ConfigurationInfo& ConfigurationInfo::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("arn")) {
    m_arn = jsonValue.GetString("arn");
    m_arnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("revision")) {
    m_revision = jsonValue.GetInt64("revision");
    m_revisionHasBeenSet = true;
  }
  return *this;
}

JsonValue ConfigurationInfo::Jsonize() const {
  JsonValue payload;

  if (m_arnHasBeenSet) {
    payload.WithString("arn", m_arn);
  }

  if (m_revisionHasBeenSet) {
    payload.WithInt64("revision", m_revision);
  }

  return payload;
}

}  // namespace Model
}  // namespace Kafka
}  // namespace Aws
