﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/kafka/model/UpdateBrokerTypeRequest.h>

#include <utility>

using namespace Aws::Kafka::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String UpdateBrokerTypeRequest::SerializePayload() const {
  JsonValue payload;

  if (m_currentVersionHasBeenSet) {
    payload.WithString("currentVersion", m_currentVersion);
  }

  if (m_targetInstanceTypeHasBeenSet) {
    payload.WithString("targetInstanceType", m_targetInstanceType);
  }

  return payload.View().WriteReadable();
}
