﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/kinesis/model/CreateStreamRequest.h>

#include <utility>

using namespace Aws::Kinesis::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String CreateStreamRequest::SerializePayload() const {
  JsonValue payload;

  if (m_streamNameHasBeenSet) {
    payload.WithString("StreamName", m_streamName);
  }

  if (m_shardCountHasBeenSet) {
    payload.WithInteger("ShardCount", m_shardCount);
  }

  if (m_streamModeDetailsHasBeenSet) {
    payload.WithObject("StreamModeDetails", m_streamModeDetails.Jsonize());
  }

  if (m_tagsHasBeenSet) {
    JsonValue tagsJsonMap;
    for (auto& tagsItem : m_tags) {
      tagsJsonMap.WithString(tagsItem.first, tagsItem.second);
    }
    payload.WithObject("Tags", std::move(tagsJsonMap));
  }

  if (m_warmThroughputMiBpsHasBeenSet) {
    payload.WithInteger("WarmThroughputMiBps", m_warmThroughputMiBps);
  }

  if (m_maxRecordSizeInKiBHasBeenSet) {
    payload.WithInteger("MaxRecordSizeInKiB", m_maxRecordSizeInKiB);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection CreateStreamRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "Kinesis_20131202.CreateStream"));
  return headers;
}
