﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/kinesisanalytics/model/DiscoverInputSchemaRequest.h>

#include <utility>

using namespace Aws::KinesisAnalytics::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String DiscoverInputSchemaRequest::SerializePayload() const {
  JsonValue payload;

  if (m_resourceARNHasBeenSet) {
    payload.WithString("ResourceARN", m_resourceARN);
  }

  if (m_roleARNHasBeenSet) {
    payload.WithString("RoleARN", m_roleARN);
  }

  if (m_inputStartingPositionConfigurationHasBeenSet) {
    payload.WithObject("InputStartingPositionConfiguration", m_inputStartingPositionConfiguration.Jsonize());
  }

  if (m_s3ConfigurationHasBeenSet) {
    payload.WithObject("S3Configuration", m_s3Configuration.Jsonize());
  }

  if (m_inputProcessingConfigurationHasBeenSet) {
    payload.WithObject("InputProcessingConfiguration", m_inputProcessingConfiguration.Jsonize());
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DiscoverInputSchemaRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "KinesisAnalytics_20150814.DiscoverInputSchema"));
  return headers;
}
