﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/kinesisanalytics/model/ListApplicationsResult.h>

#include <utility>

using namespace Aws::KinesisAnalytics::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListApplicationsResult::ListApplicationsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListApplicationsResult& ListApplicationsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("ApplicationSummaries")) {
    Aws::Utils::Array<JsonView> applicationSummariesJsonList = jsonValue.GetArray("ApplicationSummaries");
    for (unsigned applicationSummariesIndex = 0; applicationSummariesIndex < applicationSummariesJsonList.GetLength();
         ++applicationSummariesIndex) {
      m_applicationSummaries.push_back(applicationSummariesJsonList[applicationSummariesIndex].AsObject());
    }
    m_applicationSummariesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("HasMoreApplications")) {
    m_hasMoreApplications = jsonValue.GetBool("HasMoreApplications");
    m_hasMoreApplicationsHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
