﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/lexv2-models/model/ConversationLevelTestResults.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace LexModelsV2 {
namespace Model {

ConversationLevelTestResults::ConversationLevelTestResults(JsonView jsonValue) { *this = jsonValue; }

ConversationLevelTestResults& ConversationLevelTestResults::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("items")) {
    Aws::Utils::Array<JsonView> itemsJsonList = jsonValue.GetArray("items");
    for (unsigned itemsIndex = 0; itemsIndex < itemsJsonList.GetLength(); ++itemsIndex) {
      m_items.push_back(itemsJsonList[itemsIndex].AsObject());
    }
    m_itemsHasBeenSet = true;
  }
  return *this;
}

JsonValue ConversationLevelTestResults::Jsonize() const {
  JsonValue payload;

  if (m_itemsHasBeenSet) {
    Aws::Utils::Array<JsonValue> itemsJsonList(m_items.size());
    for (unsigned itemsIndex = 0; itemsIndex < itemsJsonList.GetLength(); ++itemsIndex) {
      itemsJsonList[itemsIndex].AsObject(m_items[itemsIndex].Jsonize());
    }
    payload.WithArray("items", std::move(itemsJsonList));
  }

  return payload;
}

}  // namespace Model
}  // namespace LexModelsV2
}  // namespace Aws
