﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/lexv2-models/model/ConversationLogsDataSource.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace LexModelsV2 {
namespace Model {

ConversationLogsDataSource::ConversationLogsDataSource(JsonView jsonValue) { *this = jsonValue; }

ConversationLogsDataSource& ConversationLogsDataSource::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("botId")) {
    m_botId = jsonValue.GetString("botId");
    m_botIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("botAliasId")) {
    m_botAliasId = jsonValue.GetString("botAliasId");
    m_botAliasIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("localeId")) {
    m_localeId = jsonValue.GetString("localeId");
    m_localeIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("filter")) {
    m_filter = jsonValue.GetObject("filter");
    m_filterHasBeenSet = true;
  }
  return *this;
}

JsonValue ConversationLogsDataSource::Jsonize() const {
  JsonValue payload;

  if (m_botIdHasBeenSet) {
    payload.WithString("botId", m_botId);
  }

  if (m_botAliasIdHasBeenSet) {
    payload.WithString("botAliasId", m_botAliasId);
  }

  if (m_localeIdHasBeenSet) {
    payload.WithString("localeId", m_localeId);
  }

  if (m_filterHasBeenSet) {
    payload.WithObject("filter", m_filter.Jsonize());
  }

  return payload;
}

}  // namespace Model
}  // namespace LexModelsV2
}  // namespace Aws
