﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/lexv2-models/model/CreateTestSetDiscrepancyReportRequest.h>

#include <utility>

using namespace Aws::LexModelsV2::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String CreateTestSetDiscrepancyReportRequest::SerializePayload() const {
  JsonValue payload;

  if (m_targetHasBeenSet) {
    payload.WithObject("target", m_target.Jsonize());
  }

  return payload.View().WriteReadable();
}
