﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/lexv2-models/model/GenerateBotElementRequest.h>

#include <utility>

using namespace Aws::LexModelsV2::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String GenerateBotElementRequest::SerializePayload() const {
  JsonValue payload;

  if (m_intentIdHasBeenSet) {
    payload.WithString("intentId", m_intentId);
  }

  return payload.View().WriteReadable();
}
