﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/lexv2-models/model/GenerationSortBy.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace LexModelsV2 {
namespace Model {

GenerationSortBy::GenerationSortBy(JsonView jsonValue) { *this = jsonValue; }

GenerationSortBy& GenerationSortBy::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("attribute")) {
    m_attribute = GenerationSortByAttributeMapper::GetGenerationSortByAttributeForName(jsonValue.GetString("attribute"));
    m_attributeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("order")) {
    m_order = SortOrderMapper::GetSortOrderForName(jsonValue.GetString("order"));
    m_orderHasBeenSet = true;
  }
  return *this;
}

JsonValue GenerationSortBy::Jsonize() const {
  JsonValue payload;

  if (m_attributeHasBeenSet) {
    payload.WithString("attribute", GenerationSortByAttributeMapper::GetNameForGenerationSortByAttribute(m_attribute));
  }

  if (m_orderHasBeenSet) {
    payload.WithString("order", SortOrderMapper::GetNameForSortOrder(m_order));
  }

  return payload;
}

}  // namespace Model
}  // namespace LexModelsV2
}  // namespace Aws
