﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/lexv2-models/model/ImportFilterOperator.h>

using namespace Aws::Utils;

namespace Aws {
namespace LexModelsV2 {
namespace Model {
namespace ImportFilterOperatorMapper {

static const int CO_HASH = HashingUtils::HashString("CO");
static const int EQ_HASH = HashingUtils::HashString("EQ");

ImportFilterOperator GetImportFilterOperatorForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == CO_HASH) {
    return ImportFilterOperator::CO;
  } else if (hashCode == EQ_HASH) {
    return ImportFilterOperator::EQ;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<ImportFilterOperator>(hashCode);
  }

  return ImportFilterOperator::NOT_SET;
}

Aws::String GetNameForImportFilterOperator(ImportFilterOperator enumValue) {
  switch (enumValue) {
    case ImportFilterOperator::NOT_SET:
      return {};
    case ImportFilterOperator::CO:
      return "CO";
    case ImportFilterOperator::EQ:
      return "EQ";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace ImportFilterOperatorMapper
}  // namespace Model
}  // namespace LexModelsV2
}  // namespace Aws
