﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/lexv2-models/model/NluImprovementSpecification.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace LexModelsV2 {
namespace Model {

NluImprovementSpecification::NluImprovementSpecification(JsonView jsonValue) { *this = jsonValue; }

NluImprovementSpecification& NluImprovementSpecification::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("enabled")) {
    m_enabled = jsonValue.GetBool("enabled");
    m_enabledHasBeenSet = true;
  }
  if (jsonValue.ValueExists("assistedNluMode")) {
    m_assistedNluMode = AssistedNluModeMapper::GetAssistedNluModeForName(jsonValue.GetString("assistedNluMode"));
    m_assistedNluModeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("intentDisambiguationSettings")) {
    m_intentDisambiguationSettings = jsonValue.GetObject("intentDisambiguationSettings");
    m_intentDisambiguationSettingsHasBeenSet = true;
  }
  return *this;
}

JsonValue NluImprovementSpecification::Jsonize() const {
  JsonValue payload;

  if (m_enabledHasBeenSet) {
    payload.WithBool("enabled", m_enabled);
  }

  if (m_assistedNluModeHasBeenSet) {
    payload.WithString("assistedNluMode", AssistedNluModeMapper::GetNameForAssistedNluMode(m_assistedNluMode));
  }

  if (m_intentDisambiguationSettingsHasBeenSet) {
    payload.WithObject("intentDisambiguationSettings", m_intentDisambiguationSettings.Jsonize());
  }

  return payload;
}

}  // namespace Model
}  // namespace LexModelsV2
}  // namespace Aws
