﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/lexv2-models/model/RuntimeHintValue.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace LexModelsV2 {
namespace Model {

RuntimeHintValue::RuntimeHintValue(JsonView jsonValue) { *this = jsonValue; }

RuntimeHintValue& RuntimeHintValue::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("phrase")) {
    m_phrase = jsonValue.GetString("phrase");
    m_phraseHasBeenSet = true;
  }
  return *this;
}

JsonValue RuntimeHintValue::Jsonize() const {
  JsonValue payload;

  if (m_phraseHasBeenSet) {
    payload.WithString("phrase", m_phrase);
  }

  return payload;
}

}  // namespace Model
}  // namespace LexModelsV2
}  // namespace Aws
