﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/lexv2-models/model/TextInputSpecification.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace LexModelsV2 {
namespace Model {

TextInputSpecification::TextInputSpecification(JsonView jsonValue) { *this = jsonValue; }

TextInputSpecification& TextInputSpecification::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("startTimeoutMs")) {
    m_startTimeoutMs = jsonValue.GetInteger("startTimeoutMs");
    m_startTimeoutMsHasBeenSet = true;
  }
  return *this;
}

JsonValue TextInputSpecification::Jsonize() const {
  JsonValue payload;

  if (m_startTimeoutMsHasBeenSet) {
    payload.WithInteger("startTimeoutMs", m_startTimeoutMs);
  }

  return payload;
}

}  // namespace Model
}  // namespace LexModelsV2
}  // namespace Aws
