﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/lightsail/model/AccessRules.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace Lightsail {
namespace Model {

AccessRules::AccessRules(JsonView jsonValue) { *this = jsonValue; }

AccessRules& AccessRules::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("getObject")) {
    m_getObject = AccessTypeMapper::GetAccessTypeForName(jsonValue.GetString("getObject"));
    m_getObjectHasBeenSet = true;
  }
  if (jsonValue.ValueExists("allowPublicOverrides")) {
    m_allowPublicOverrides = jsonValue.GetBool("allowPublicOverrides");
    m_allowPublicOverridesHasBeenSet = true;
  }
  return *this;
}

JsonValue AccessRules::Jsonize() const {
  JsonValue payload;

  if (m_getObjectHasBeenSet) {
    payload.WithString("getObject", AccessTypeMapper::GetNameForAccessType(m_getObject));
  }

  if (m_allowPublicOverridesHasBeenSet) {
    payload.WithBool("allowPublicOverrides", m_allowPublicOverrides);
  }

  return payload;
}

}  // namespace Model
}  // namespace Lightsail
}  // namespace Aws
