﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/lightsail/model/BucketCorsConfig.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace Lightsail {
namespace Model {

BucketCorsConfig::BucketCorsConfig(JsonView jsonValue) { *this = jsonValue; }

BucketCorsConfig& BucketCorsConfig::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("rules")) {
    Aws::Utils::Array<JsonView> rulesJsonList = jsonValue.GetArray("rules");
    for (unsigned rulesIndex = 0; rulesIndex < rulesJsonList.GetLength(); ++rulesIndex) {
      m_rules.push_back(rulesJsonList[rulesIndex].AsObject());
    }
    m_rulesHasBeenSet = true;
  }
  return *this;
}

JsonValue BucketCorsConfig::Jsonize() const {
  JsonValue payload;

  if (m_rulesHasBeenSet) {
    Aws::Utils::Array<JsonValue> rulesJsonList(m_rules.size());
    for (unsigned rulesIndex = 0; rulesIndex < rulesJsonList.GetLength(); ++rulesIndex) {
      rulesJsonList[rulesIndex].AsObject(m_rules[rulesIndex].Jsonize());
    }
    payload.WithArray("rules", std::move(rulesJsonList));
  }

  return payload;
}

}  // namespace Model
}  // namespace Lightsail
}  // namespace Aws
