﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/lightsail/model/StaticIp.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace Lightsail {
namespace Model {

StaticIp::StaticIp(JsonView jsonValue) { *this = jsonValue; }

StaticIp& StaticIp::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("name")) {
    m_name = jsonValue.GetString("name");
    m_nameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("arn")) {
    m_arn = jsonValue.GetString("arn");
    m_arnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("supportCode")) {
    m_supportCode = jsonValue.GetString("supportCode");
    m_supportCodeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("createdAt")) {
    m_createdAt = jsonValue.GetDouble("createdAt");
    m_createdAtHasBeenSet = true;
  }
  if (jsonValue.ValueExists("location")) {
    m_location = jsonValue.GetObject("location");
    m_locationHasBeenSet = true;
  }
  if (jsonValue.ValueExists("resourceType")) {
    m_resourceType = ResourceTypeMapper::GetResourceTypeForName(jsonValue.GetString("resourceType"));
    m_resourceTypeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("ipAddress")) {
    m_ipAddress = jsonValue.GetString("ipAddress");
    m_ipAddressHasBeenSet = true;
  }
  if (jsonValue.ValueExists("attachedTo")) {
    m_attachedTo = jsonValue.GetString("attachedTo");
    m_attachedToHasBeenSet = true;
  }
  if (jsonValue.ValueExists("isAttached")) {
    m_isAttached = jsonValue.GetBool("isAttached");
    m_isAttachedHasBeenSet = true;
  }
  return *this;
}

JsonValue StaticIp::Jsonize() const {
  JsonValue payload;

  if (m_nameHasBeenSet) {
    payload.WithString("name", m_name);
  }

  if (m_arnHasBeenSet) {
    payload.WithString("arn", m_arn);
  }

  if (m_supportCodeHasBeenSet) {
    payload.WithString("supportCode", m_supportCode);
  }

  if (m_createdAtHasBeenSet) {
    payload.WithDouble("createdAt", m_createdAt.SecondsWithMSPrecision());
  }

  if (m_locationHasBeenSet) {
    payload.WithObject("location", m_location.Jsonize());
  }

  if (m_resourceTypeHasBeenSet) {
    payload.WithString("resourceType", ResourceTypeMapper::GetNameForResourceType(m_resourceType));
  }

  if (m_ipAddressHasBeenSet) {
    payload.WithString("ipAddress", m_ipAddress);
  }

  if (m_attachedToHasBeenSet) {
    payload.WithString("attachedTo", m_attachedTo);
  }

  if (m_isAttachedHasBeenSet) {
    payload.WithBool("isAttached", m_isAttached);
  }

  return payload;
}

}  // namespace Model
}  // namespace Lightsail
}  // namespace Aws
