﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/lookoutequipment/model/CreateInferenceSchedulerRequest.h>

#include <utility>

using namespace Aws::LookoutEquipment::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String CreateInferenceSchedulerRequest::SerializePayload() const {
  JsonValue payload;

  if (m_modelNameHasBeenSet) {
    payload.WithString("ModelName", m_modelName);
  }

  if (m_inferenceSchedulerNameHasBeenSet) {
    payload.WithString("InferenceSchedulerName", m_inferenceSchedulerName);
  }

  if (m_dataDelayOffsetInMinutesHasBeenSet) {
    payload.WithInt64("DataDelayOffsetInMinutes", m_dataDelayOffsetInMinutes);
  }

  if (m_dataUploadFrequencyHasBeenSet) {
    payload.WithString("DataUploadFrequency", DataUploadFrequencyMapper::GetNameForDataUploadFrequency(m_dataUploadFrequency));
  }

  if (m_dataInputConfigurationHasBeenSet) {
    payload.WithObject("DataInputConfiguration", m_dataInputConfiguration.Jsonize());
  }

  if (m_dataOutputConfigurationHasBeenSet) {
    payload.WithObject("DataOutputConfiguration", m_dataOutputConfiguration.Jsonize());
  }

  if (m_roleArnHasBeenSet) {
    payload.WithString("RoleArn", m_roleArn);
  }

  if (m_serverSideKmsKeyIdHasBeenSet) {
    payload.WithString("ServerSideKmsKeyId", m_serverSideKmsKeyId);
  }

  if (m_clientTokenHasBeenSet) {
    payload.WithString("ClientToken", m_clientToken);
  }

  if (m_tagsHasBeenSet) {
    Aws::Utils::Array<JsonValue> tagsJsonList(m_tags.size());
    for (unsigned tagsIndex = 0; tagsIndex < tagsJsonList.GetLength(); ++tagsIndex) {
      tagsJsonList[tagsIndex].AsObject(m_tags[tagsIndex].Jsonize());
    }
    payload.WithArray("Tags", std::move(tagsJsonList));
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection CreateInferenceSchedulerRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AWSLookoutEquipmentFrontendService.CreateInferenceScheduler"));
  return headers;
}
