﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/lookoutequipment/model/DeleteDatasetRequest.h>

#include <utility>

using namespace Aws::LookoutEquipment::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String DeleteDatasetRequest::SerializePayload() const {
  JsonValue payload;

  if (m_datasetNameHasBeenSet) {
    payload.WithString("DatasetName", m_datasetName);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DeleteDatasetRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AWSLookoutEquipmentFrontendService.DeleteDataset"));
  return headers;
}
