﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/machinelearning/model/CreateDataSourceFromRDSRequest.h>

#include <utility>

using namespace Aws::MachineLearning::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String CreateDataSourceFromRDSRequest::SerializePayload() const {
  JsonValue payload;

  if (m_dataSourceIdHasBeenSet) {
    payload.WithString("DataSourceId", m_dataSourceId);
  }

  if (m_dataSourceNameHasBeenSet) {
    payload.WithString("DataSourceName", m_dataSourceName);
  }

  if (m_rDSDataHasBeenSet) {
    payload.WithObject("RDSData", m_rDSData.Jsonize());
  }

  if (m_roleARNHasBeenSet) {
    payload.WithString("RoleARN", m_roleARN);
  }

  if (m_computeStatisticsHasBeenSet) {
    payload.WithBool("ComputeStatistics", m_computeStatistics);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection CreateDataSourceFromRDSRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AmazonML_20141212.CreateDataSourceFromRDS"));
  return headers;
}
