﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/mailmanager/model/GetRuleSetResult.h>

#include <utility>

using namespace Aws::MailManager::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

GetRuleSetResult::GetRuleSetResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

GetRuleSetResult& GetRuleSetResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("RuleSetId")) {
    m_ruleSetId = jsonValue.GetString("RuleSetId");
    m_ruleSetIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("RuleSetArn")) {
    m_ruleSetArn = jsonValue.GetString("RuleSetArn");
    m_ruleSetArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("RuleSetName")) {
    m_ruleSetName = jsonValue.GetString("RuleSetName");
    m_ruleSetNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("CreatedDate")) {
    m_createdDate = jsonValue.GetDouble("CreatedDate");
    m_createdDateHasBeenSet = true;
  }
  if (jsonValue.ValueExists("LastModificationDate")) {
    m_lastModificationDate = jsonValue.GetDouble("LastModificationDate");
    m_lastModificationDateHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Rules")) {
    Aws::Utils::Array<JsonView> rulesJsonList = jsonValue.GetArray("Rules");
    for (unsigned rulesIndex = 0; rulesIndex < rulesJsonList.GetLength(); ++rulesIndex) {
      m_rules.push_back(rulesJsonList[rulesIndex].AsObject());
    }
    m_rulesHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
