﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/mailmanager/model/IngressIpv6ToEvaluate.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace MailManager {
namespace Model {

IngressIpv6ToEvaluate::IngressIpv6ToEvaluate(JsonView jsonValue) { *this = jsonValue; }

IngressIpv6ToEvaluate& IngressIpv6ToEvaluate::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("Attribute")) {
    m_attribute = IngressIpv6AttributeMapper::GetIngressIpv6AttributeForName(jsonValue.GetString("Attribute"));
    m_attributeHasBeenSet = true;
  }
  return *this;
}

JsonValue IngressIpv6ToEvaluate::Jsonize() const {
  JsonValue payload;

  if (m_attributeHasBeenSet) {
    payload.WithString("Attribute", IngressIpv6AttributeMapper::GetNameForIngressIpv6Attribute(m_attribute));
  }

  return payload;
}

}  // namespace Model
}  // namespace MailManager
}  // namespace Aws
