﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/mailmanager/model/ListTrafficPoliciesResult.h>

#include <utility>

using namespace Aws::MailManager::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListTrafficPoliciesResult::ListTrafficPoliciesResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListTrafficPoliciesResult& ListTrafficPoliciesResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("TrafficPolicies")) {
    Aws::Utils::Array<JsonView> trafficPoliciesJsonList = jsonValue.GetArray("TrafficPolicies");
    for (unsigned trafficPoliciesIndex = 0; trafficPoliciesIndex < trafficPoliciesJsonList.GetLength(); ++trafficPoliciesIndex) {
      m_trafficPolicies.push_back(trafficPoliciesJsonList[trafficPoliciesIndex].AsObject());
    }
    m_trafficPoliciesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("NextToken")) {
    m_nextToken = jsonValue.GetString("NextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
