﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/mailmanager/model/PrivateNetworkConfiguration.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace MailManager {
namespace Model {

PrivateNetworkConfiguration::PrivateNetworkConfiguration(JsonView jsonValue) { *this = jsonValue; }

PrivateNetworkConfiguration& PrivateNetworkConfiguration::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("VpcEndpointId")) {
    m_vpcEndpointId = jsonValue.GetString("VpcEndpointId");
    m_vpcEndpointIdHasBeenSet = true;
  }
  return *this;
}

JsonValue PrivateNetworkConfiguration::Jsonize() const {
  JsonValue payload;

  if (m_vpcEndpointIdHasBeenSet) {
    payload.WithString("VpcEndpointId", m_vpcEndpointId);
  }

  return payload;
}

}  // namespace Model
}  // namespace MailManager
}  // namespace Aws
