﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/mediapackage-vod/model/DashEncryption.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace MediaPackageVod {
namespace Model {

DashEncryption::DashEncryption(JsonView jsonValue) { *this = jsonValue; }

DashEncryption& DashEncryption::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("spekeKeyProvider")) {
    m_spekeKeyProvider = jsonValue.GetObject("spekeKeyProvider");
    m_spekeKeyProviderHasBeenSet = true;
  }
  return *this;
}

JsonValue DashEncryption::Jsonize() const {
  JsonValue payload;

  if (m_spekeKeyProviderHasBeenSet) {
    payload.WithObject("spekeKeyProvider", m_spekeKeyProvider.Jsonize());
  }

  return payload;
}

}  // namespace Model
}  // namespace MediaPackageVod
}  // namespace Aws
