﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/mediapackage-vod/model/HlsManifest.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace MediaPackageVod {
namespace Model {

HlsManifest::HlsManifest(JsonView jsonValue) { *this = jsonValue; }

HlsManifest& HlsManifest::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("adMarkers")) {
    m_adMarkers = AdMarkersMapper::GetAdMarkersForName(jsonValue.GetString("adMarkers"));
    m_adMarkersHasBeenSet = true;
  }
  if (jsonValue.ValueExists("includeIframeOnlyStream")) {
    m_includeIframeOnlyStream = jsonValue.GetBool("includeIframeOnlyStream");
    m_includeIframeOnlyStreamHasBeenSet = true;
  }
  if (jsonValue.ValueExists("manifestName")) {
    m_manifestName = jsonValue.GetString("manifestName");
    m_manifestNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("programDateTimeIntervalSeconds")) {
    m_programDateTimeIntervalSeconds = jsonValue.GetInteger("programDateTimeIntervalSeconds");
    m_programDateTimeIntervalSecondsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("repeatExtXKey")) {
    m_repeatExtXKey = jsonValue.GetBool("repeatExtXKey");
    m_repeatExtXKeyHasBeenSet = true;
  }
  if (jsonValue.ValueExists("streamSelection")) {
    m_streamSelection = jsonValue.GetObject("streamSelection");
    m_streamSelectionHasBeenSet = true;
  }
  return *this;
}

JsonValue HlsManifest::Jsonize() const {
  JsonValue payload;

  if (m_adMarkersHasBeenSet) {
    payload.WithString("adMarkers", AdMarkersMapper::GetNameForAdMarkers(m_adMarkers));
  }

  if (m_includeIframeOnlyStreamHasBeenSet) {
    payload.WithBool("includeIframeOnlyStream", m_includeIframeOnlyStream);
  }

  if (m_manifestNameHasBeenSet) {
    payload.WithString("manifestName", m_manifestName);
  }

  if (m_programDateTimeIntervalSecondsHasBeenSet) {
    payload.WithInteger("programDateTimeIntervalSeconds", m_programDateTimeIntervalSeconds);
  }

  if (m_repeatExtXKeyHasBeenSet) {
    payload.WithBool("repeatExtXKey", m_repeatExtXKey);
  }

  if (m_streamSelectionHasBeenSet) {
    payload.WithObject("streamSelection", m_streamSelection.Jsonize());
  }

  return payload;
}

}  // namespace Model
}  // namespace MediaPackageVod
}  // namespace Aws
