﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/mq/model/ConflictException.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace MQ {
namespace Model {

ConflictException::ConflictException(JsonView jsonValue) { *this = jsonValue; }

ConflictException& ConflictException::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("errorAttribute")) {
    m_errorAttribute = jsonValue.GetString("errorAttribute");
    m_errorAttributeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("message")) {
    m_message = jsonValue.GetString("message");
    m_messageHasBeenSet = true;
  }
  return *this;
}

JsonValue ConflictException::Jsonize() const {
  JsonValue payload;

  if (m_errorAttributeHasBeenSet) {
    payload.WithString("errorAttribute", m_errorAttribute);
  }

  if (m_messageHasBeenSet) {
    payload.WithString("message", m_message);
  }

  return payload;
}

}  // namespace Model
}  // namespace MQ
}  // namespace Aws
