﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/mturk-requester/model/UpdateHITTypeOfHITRequest.h>

#include <utility>

using namespace Aws::MTurk::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String UpdateHITTypeOfHITRequest::SerializePayload() const {
  JsonValue payload;

  if (m_hITIdHasBeenSet) {
    payload.WithString("HITId", m_hITId);
  }

  if (m_hITTypeIdHasBeenSet) {
    payload.WithString("HITTypeId", m_hITTypeId);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection UpdateHITTypeOfHITRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "MTurkRequesterServiceV20170117.UpdateHITTypeOfHIT"));
  return headers;
}
